/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.exceptions;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscBaseException;

public class PIHscClientException
extends PIHscBaseException {
    private String m_message = "";
    private String m_bundleName = null;
    private String m_msgId = null;
    private String[] m_args = null;

    public PIHscClientException(String string) {
        super((String)null);
        this.procParams(string);
    }

    public PIHscClientException(String string, String string2, String string3) {
        this(string, string2, string3, null, null);
    }

    public PIHscClientException(String string, String string2, String string3, String[] stringArray) {
        this(string, string2, string3, stringArray, null);
    }

    public PIHscClientException(String string, String string2, String string3, String[] stringArray, Throwable throwable) {
        super((String)null);
        boolean bl;
        String string4 = "";
        int n = 0;
        if (throwable != null) {
            string4 = this.getStackTrace(throwable);
        }
        boolean bl2 = bl = stringArray != null && stringArray.length > 0;
        if (bl) {
            n = stringArray.length;
        }
        String string5 = "HSCExceptionDelimiter=" + string + "HSCExceptionDelimiter=" + string4 + "HSCExceptionDelimiter=" + this.alreadyLogged() + "HSCExceptionDelimiter=" + string2 + "HSCExceptionDelimiter=" + string3 + "HSCExceptionDelimiter=" + n;
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                string5 = string5 + "HSCExceptionDelimiter=" + stringArray[i];
            }
        }
        string5 = string5 + "HSCExceptionDelimiter=";
        this.procParams(string5);
    }

    private void procParams(String string) {
        int n;
        int n2 = 0;
        this._hscExId = this.getToken(string, n2++);
        this._stackTrace = this.getToken(string, n2++);
        try {
            String string2 = this.getToken(string, n2++);
            this._alreadyLogged = new Boolean(string2);
        }
        catch (Exception exception) {
            this._alreadyLogged = false;
        }
        this.m_bundleName = this.getToken(string, n2++);
        this.m_msgId = this.getToken(string, n2++);
        try {
            n = Integer.parseInt(this.getToken(string, n2++));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n > 0) {
            this.m_args = new String[n];
            for (int i = 0; i < n; ++i) {
                this.m_args[i] = HSCResourceBundleUtil.decodeNLSMsgs(this.getToken(string, n2++));
            }
            this.m_message = HSCResourceBundleUtil.getMessage(this.m_bundleName, this.m_msgId, this.m_message, this.m_args);
        } else {
            this.m_message = HSCResourceBundleUtil.getMessage(this.m_bundleName, this.m_msgId, this.m_message);
        }
    }

    protected String getToken(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n + 1; ++i) {
            n2 = string.indexOf("HSCExceptionDelimiter=", n2);
            n3 = string.indexOf("HSCExceptionDelimiter=", n2 += "HSCExceptionDelimiter=".length());
        }
        String string2 = string.substring(n2, n3);
        return string2;
    }

    public String getMessage() {
        return this.m_message;
    }

    public void printStackTrace() {
        if (this._stackTrace != null) {
            System.err.print(this._stackTrace);
        } else {
            super.printStackTrace();
        }
    }

    public void debugPrint() {
        System.out.println("PIHscClientException.hscExId       = >" + this.getHscExId() + "<");
        System.out.println("PIHscClientException.alreadyLogged = >" + this.alreadyLogged() + "<");
        System.out.println("PIHscClientException.stackTrace    = >" + this.getStackTraceString() + "<");
        System.out.println("PIHscClientException.message       = >" + this.m_message + "<");
        System.out.println("PIHscClientException.args          = >" + this.m_args + "<");
    }

    public String[] getArgs() {
        return this.m_args;
    }

    public String getBundleName() {
        return this.m_bundleName;
    }

    public String getMsgId() {
        return this.m_msgId;
    }
}

